/**
 ****************************************************************************
 * @file     D_Para_ch1.h
 * @brief    Motor vector control Parameter Header File for CH1
 * @version  V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2021
 *****************************************************************************
 */
#ifndef _D_PARA_CH1_H
#define _D_PARA_CH1_H


/*===================================================================*
	  Select Board type (Only valid in METIS board)
 *===================================================================*/

/*===================================================================*
	  Select parts
 *===================================================================*/

/*===================================================================*
	  Board Parameter Definition
 *===================================================================*/
/******** METIS High voltage board **********************/
  /* High/Low side driver logic */
  #define	cPOLH_CH1				(1)					/* High side	 0:Low active, 1:High active */
  #define	cPOLL_CH1				(1)					/* Low	side	 0:Low active, 1:High active */

  /* V MAX */
  #define	cV_MAX_CH1				(473.0f)			/* [V] Input voltage(Vdc)  at ADC =0xFFF0(5V) */

  /* A MAX */
  #define	cA_MAX_CH1				(8.32f)				/* [A] Input current(Iabc) at ADC =0xFFF0(5V) */

/* Current detection Type */
#define	cSHUNT_TYPE_CH1 			(3)					/* 1 : 1-shunt, 3 : 3-shunt */
#define	cBOOT_TYPE_CH1				(cBoot_i)			/* cBoot_i : Current control, cBoot_v: Volt control */
//#define	cSHUNT_TYPE_CH1 			(1)					/* 1 : 1-shunt, 3 : 3-shunt */
//#define	cBOOT_TYPE_CH1				(cBoot_v)			/* cBoot_i : Current control, cBoot_v: Volt control */

#define	cSHUNT_ZERO_OFFSET_CH1		(2.5f)				/* [V] Shunt ad offset voltage (shunt ad voltage of 0A) */

/* AD Channel */
#define	cADCH_CURRENT_U_CH1		(2)					/* AD channel for U-phase current of 3shunt */
#define	cADCH_CURRENT_V_CH1		(3)					/* AD channel for V-phase current of 3shunt */
#define	cADCH_CURRENT_W_CH1		(9)					/* AD channel for W-phase current of 3shunt */
#define	cADCH_CURRENT_IDC_CH1	(3)					/* AD Channel for DC current of 1shunt */

#define	cADCH_VDC_CH1			(10)				/* AD Channel for power supply voltage */

/* Over current */
#define	cOVC_CH1					(1.2f)				/* [A] Over current  */

/* Over voltage */
#define	cVDC_MINLIM_CH1				(1.0f)				/* [V] Vdc min limit */
#define	cVDC_MAXLIM_CH1				(cV_MAX_CH1 - 1.0f)	/* [V] Vdc max limit */

/*===================================================================*
	  Motor Parameter Definition
 *===================================================================*/
/* PWM Parameter */
#define	cPWMPRD_CH1 				(64.0f)				/* [us] PWM Period */
#define	cDEADTIME_CH1				(1.4f)				/* [us] Dead time */
#define	cREPTIME_CH1				(1)					/* Repeat time */

/* External specification */
#define	cSPEED_ACT_CH1				(0.0f)				/* [Hz or RPM] Target speed of motor */

#define	cID_ST_USER_ACT_CH1			(0.55f)				/* [A] Start current (Id) */
#define	cIQ_ST_USER_ACT_CH1			(0.28f)				/* [A] Start current (Iq) */

/* Motor Parameter */
#define	cMOTOR_R_CH1				(72.6f)				/* [Ohm] Winding resistance */
#define	cMOTOR_LQ_CH1				(321.9f)			/* [mH] q-axis inductance */
#define	cMOTOR_LD_CH1				(cMOTOR_LQ_CH1)		/* [mH] d-axis inductance */
#define	cPOLE_CH1					(8)					/* [Pole] Poles of the motor */

/* Control Gain constant */
#define	cID_KP_CH1					(56.7469f)			/* [V/A]  d-axis current control Proportinal gain */
#define	cID_KI_CH1					(7317.5f)			/* [V/As] d-axis current control Integral gain */
#define	cIQ_KP_CH1					(cID_KP_CH1)		/* [V/A]  q-axis current control Proportinal gain */
#define	cIQ_KI_CH1					(cID_KI_CH1)		/* [V/As] q-axis current control Integral gain */

#define	cPOSITION_KP_CH1			(7.0763875f/35)		/* [Hz/V]  Position estimation Proportinal gain (Kp) */
#define	cPOSITION_KI_CH1			(0.024271f*35)		/* [Hz/Vs] Position estimation Integral gain (Ki) */
#define	cSPEED_KP_CH1				(0.01995f)			/* [A/Hz]  Speed Control Proportinal gain */
#define	cSPEED_KI_CH1				(0.036f)			/* [A/Hzs] Speed Control Integral gain */

#define	cSPD_PI_PRD_CH1				(1)					/* Speed PI period */

#define	cFCD_UD_LIM_CH1				(15.0f)				/* [Hz/s] Limitation of the increase value (Forced Stage) */
#define	cSTD_UP_LIM_CH1				(10.0f)				/* [Hz/s] Limitation of the increase value (Steady Stage) */
#define	cSTD_DW_LIM_CH1				(10.0f)				/* [Hz/s] Limitation of the decrease value (Steady Stage) */

#define	cBOOT_LEN_CH1				(0.5f)				/* [s] Time of Bootstrap Stage */
#define	cINIT_LEN_CH1				(0.5f)				/* [s] Time of Positioning Stage */
#define	cINIT_WAIT_LEN_CH1			(0.5f)				/* [s] Time of Positioning wait time */
#define	cGOUP_DELAY_LEN_CH1			(0.01f)				/* [s] Time of Change-up delay time */

#define	cHZ_MAX_CH1 				(220.0f)	    	/* [Hz] Maximum speed of motor */
#define	cHZ_MIN_CH1 				(35.0f)	    		/* [Hz] Minimam speed of motor */
														/* When set cHZ_MIN > S_speed_actx, not move Stage from Force */

#define	cHZ_SPWM_CH1				(100.0f)			/* [Hz] in Hz the rotating speed under which the shift PWM will work (for VE 1shunt) */
#define	cMINPLS_CH1					(3.0f)				/* [us] Minimum Pulse (for 1shunt) */
#define	cMAXPLS_CH1					(cPWMPRD_CH1 * 0.9f)/* [us] Maximum Pulse (for 3shunt) */

#define	cID_LIM_CH1 				(cOVC_CH1 * 0.9f) 	/* [A] d-axis limitation current */
#define	cIQ_LIM_CH1 				(cOVC_CH1 * 0.9f) 	/* [A] q-axis limitation current */

#define	cINITIAL_POSITION_CH1		(0)					/* [deg] Initial position */

#if (cSHUNT_TYPE_CH1 == 3)
  #define	cTRG_COMP_CH1			(0.0f)  			/* [us] Trigger compensation time for 3shunt(for SoftVector). Setting range:0 <= x < (cPWMPRD_CH1/2) */
#else
  #define	cTRG_COMP_CH1			(-1.0f)				/* [us] Trigger compensation time for 1shunt(for SoftVector). Setting range:(-cPWMPRD_CH1/2) < x < (cPWMPRD_CH1/2) */
#endif

/*for Voltage control parameter */
#define	cVD_POS_CH1					(40.0f)				/* [V] Voltage of positioning */
#define	cSPD_COEF_CH1				(0.5f)				/* [-] Speed coefficient */
#define	cHZ_V2I_CH1					(cHZ_MAX_CH1 - 1.0f)/* [Hz] Speed of switching from voltage control to current control */

/* for Encoder parameter */
#define	cENC_PULSE_NUM_CH1			(2048)				/* [ppr] Number of Encoder pulse */
#define	cENC_DEG_ADJUST_CH1			(180)				/* [deg] Adjust Z-phase,0deg of electrical-angle */

#define	cENC_NOISE_TIME_CH1			(0.1f)				/* [us] Encoder signal input noise cancel time. unit:fc/8 (for A-ENC only) */

/* for Fixed Vdc parameter */
#define __FIXED_VDC_CH1 			(0)					/* Fixed Vdc */
#define	cVDC_CH1					(280.0f)			/* [V] Power Voltage */

#define cVdVq_Average_shift_cnt_CH1	(4U)

/*===================================================================*/
/* Control period of motor */
#define	cCTRL_PRD_CH1				(cPWMPRD_CH1 * cREPTIME_CH1 * 1e-6)								/* [s] */
#define	cSPD_CTRL_PRD_CH1			(cSPD_PI_PRD_CH1 * cPWMPRD_CH1 * cREPTIME_CH1 * 1e-6)			/* [s] */


/*===================================================================*
	Parameter check
 *===================================================================*/
#if (!((cPOLH_CH1 == 0) || (cPOLH_CH1 == 1)))
#error cPOLH_CH1 define error. cPOLH_CH1 only 0 or 1.
#endif
#if (!((cPOLL_CH1 == 0) || (cPOLL_CH1 == 1)))
#error cPOLL_CH1 define error. cPOLL_CH1 only 0 or 1.
#endif


#if (!((cSHUNT_TYPE_CH1 == 1) || (cSHUNT_TYPE_CH1 == 3)))
#error cSHUNT_TYPE_CH1 define error. cSHUNT_TYPE_CH1 only 1 or 3.
#endif

#endif /* _D_PARA_CH1_H */

/*************************** END OF FILE **************************************/

