/**
 ****************************************************************************
 * @file:	 usercon.h
 * @brief:	 User control
 * @version  V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2023
 *****************************************************************************
 */
#ifndef _USERCON_H
#define _USERCON_H

#include "ipdrv_adc.h"

#undef EXTERN
#ifdef DEFINE_APP
#define EXTERN
#else
#define EXTERN  extern
#endif

/*****************************************************************
	Define for Software & Hardware seting
******************************************************************/

/*===================================================================*
	Define Typedef
*===================================================================*/
typedef struct
{
	uint8_t	sw1	: 1;
	uint8_t	sw2	: 1;
	uint8_t	sw3	: 1;
	uint8_t	sw4	: 1;
	uint8_t	sw5	: 1;
	uint8_t	sw6	: 1;
	uint8_t	sw7	: 1;
	uint8_t	sw8	: 1;
} sw_t;


typedef struct
{
	ADC_Result	rawdat;
	uint8_t		avecnt;
	uint16_t		maxdat;
	uint16_t		mindat;
	uint32_t		sumdat;
	uint16_t		avedat;
} addat_t;


typedef enum
{
    PSW_OFF		= 0,
    PSW_1		= 1,
    PSW_2		= 2,
    PSW_3		= 3,
    PSW_4		= 4
} adkeycode_e;

#if defined(__USE_microE_COMMUNICATION_FUNC)
typedef struct
{
	uint8_t	reserve			:7;			/* reserve */
	uint8_t	timeout			:1;			/* 2sec Time out flag */
} timer_t;

typedef struct
{
	uint8_t	reserve			:4;			/* reserve */
	uint8_t	data_receive	:1;			/* receive end */
	uint8_t	emg_bit			:1;			/* EMG bit */
	uint8_t	na_bit			:1;			/* N/A bit */
	uint8_t	ack_bit			:1;			/* ACK bit */
} uart_t;

typedef struct
{
	uint8_t	reserve			:6;			/* reserve */
	uint8_t	pfc_ctrl		:1;			/* pfc control */
	uint8_t	all_stop		:1;			/* motor all stop */
} motor_t;

typedef struct
{
	timer_t		timer;
	uart_t		uart;
	motor_t		motor;
} usercon_flg;
#endif /* __USE_microE_COMMUNICATION_FUNC */

/*===================================================================*
      Proto Type Definition
 *===================================================================*/
EXTERN	void	init_user_control(void);
EXTERN	void	init_TP(void);
EXTERN	void	init_NBD(void);
EXTERN void init_Relay(void);
EXTERN void Relay_On(void);
EXTERN void Relay_Off(void);
EXTERN	void	UiOutDataStartByVE(uint8_t	_intch);
EXTERN	void	UiOutDataStart(uint8_t	_intch);

#if defined(__USE_microE_COMMUNICATION_FUNC)
EXTERN void timer_count(void);
EXTERN void uart_control(void);
EXTERN void init_uart(void);
#endif /* __USE_microE_COMMUNICATION_FUNC */
/*===================================================================*
	Variable Definition
 *===================================================================*/

EXTERN	sw_t			keydata;						/* Key data */
EXTERN	adkeycode_e	push_sw, push_sw_pre;		/* Push sw code */

EXTERN uint16_t 		ad_vr_fan_val;
EXTERN uint16_t 		ad_vr_comp_val;

#if defined(__USE_microE_COMMUNICATION_FUNC)
EXTERN usercon_flg		flg;					/* User control flag */
EXTERN uint8_t			status_channel;			/* control channel */
EXTERN uint8_t			dac_mode;				/* dac mode */
EXTERN uint32_t			target_spd_fan;		 /* fan motor target speed */
EXTERN uint32_t			target_spd_comp;		/* compressor motor target speed */
#endif /* __USE_microE_COMMUNICATION_FUNC */

#undef EXTERN
#endif

/******************************** END OF FILE *********************************/
