/**
 ****************************************************************************
 * @file	D_Para.h
 * @brief	Motor vector control Parameter Header File
 * @version V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2023
 *****************************************************************************
 */
#ifndef _D_PARA_H
#define _D_PARA_H


/*===================================================================*
	  Control motor Channel
 *===================================================================*/
#define	__CONTROL_MOTOR_COMP	/* Control motor ch1 */
#define	__CONTROL_MOTOR_FAN		/* Control motor ch0 */
#define __CONTROL_PFC

/*===================================================================*
	  Select parts
 *===================================================================*/
#define	__USE_DAC		/* If define __USE_DAC, use dac ic control */
#define __USE_INAMP_COMP
#define __USE_INAMP_FAN
#define __VE_CONTROL_MOTOR_FAN
#define __SOFT_CONTROL_MOTOR_COMP

#define	__USE_microE_COMMUNICATION_FUNC

/*===================================================================*
	  Select special cotrol
 *===================================================================*/

/*===================================================================*
	  Select unit
 *===================================================================*/
#define	__TGTSPD_UNIT				(0)					/* Sletect target speed unit. [0:Hz of Electrical angle, 1:Hz of of mechanical angle, 2:RPM of mechanical angle] */

/*===================================================================*
	  Select relay control (Used only for High voltage board.)
 *===================================================================*/
#define	__RELAY			/* If define __RELAY, use relay control. */

/*===================================================================*
	  Change PI control gain's range
 *===================================================================*/
/* If define each one of the below, each item can be used in q12 format. default is in q15 format. 	
   (now, not correspond to channel-specific setting.) */
/* /#define	__POSITION_KP_RANGE */		/* Change Position estimation Proportional gain range. 	*/
/* #define	__POSITION_KI_RANGE */		/* Change Position estimation Integral gain range. 		*/
/* #define	__SPEED_KP_RANGE */			/* Change Speed Control Proportional gain range.  		*/
/* #define	__SPEED_KI_RANGE */			/* Change Speed Control Integral gain range. 			*/
/* Following define is able to use only in case of Software Vector Control.*/
/* #define	__CURRENT_DKP_RANGE */		/* Change d-axis Current Control Proportional gain range. 	*/
/* #define	__CURRENT_DKI_RANGE */		/* Change d-axis Current Control Integral gain range.  		*/
/* #define	__CURRENT_QKP_RANGE */		/* Change q-axis Current Control Proportional gain range.  	*/
/* #define	__CURRENT_QKI_RANGE */		/* Change q-axis Current Control Integral gain range. 		*/



/*===================================================================*
	  Common Parameter Definition
 *===================================================================*/
/**** Main period ****/
#define	cMAINLOOP_PRD				(0.001)				/* [s] Cycle time of MAIN control */

/**** Filter Coefficient ****/
#define	cIXO_AVE					(5)					/* Zero current filter */
#define	cVDQ_AVE					(5)					/* Vdq,Vdc filter */
#define	cOMEGAENC_AVE				(3)					/* Omega from Encoder filter */

/*===================================================================*
	  By channel parameters
 *===================================================================*/
#if defined(__CONTROL_MOTOR_COMP)
#include "D_Para_Comp.h"
#endif

#if defined(__CONTROL_MOTOR_FAN)
#include "D_Para_Fan.h"
#endif

#if defined(__CONTROL_PFC)
#include "HPFC_Para.h"
#endif

/*===================================================================*
	  parameters
 *===================================================================*/
#define	cMAINLOOP_CNT				((uint16_t)(cMAINLOOP_PRD / (250 * 1e-6)))
#define cError_None					0

#endif /* _D_PARA_H */

/*************************** END OF FILE **************************************/

