/**
 ****************************************************************************
 * @file	D_Driver.h
 * @brief	Motor vector control driver Header File
 * @version	V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2023
 *****************************************************************************
 */
#ifndef _D_DRIVER_H
#define _D_DRIVER_H

#undef EXTERN
#ifdef DEFINE_APP
#define EXTERN
#else
#define EXTERN  extern
#endif


/*===================================================================*
      Proto Type Definition
 *===================================================================*/
EXTERN uint8_t D_CalSector(q31_t _valpha, q31_t _vbeta);
EXTERN void D_CalTrgTiming(TSB_PMD_TypeDef* const PMDx, vector_t* const _motor);
EXTERN void D_Check_DetectCurrentError(vector_t* const _motor);
EXTERN void D_Detect_Rotor_Position(vector_t* const _motor);
EXTERN void D_InputTransformation(vector_t* const _motor);
EXTERN void D_OutputTransformation(vector_t* const _motor);
EXTERN q31_t D_SpeedUpReachedControl(vector_t* const _motor);
EXTERN void D_PowerCalculation(vector_t* const _motor);
EXTERN void D_SVM(q31_t _valpha, q31_t _vbeta, q15_t _vdc, uint8_t _sector, uint8_t _modul, uint16_t* _p_vu, uint16_t* _p_vv,
		  uint16_t* _p_vw);

EXTERN void H_Encoder(vector_t * const motor, TSB_EN_TypeDef * const ENx);
EXTERN void D_Control_Speed(vector_t* const _motor);
EXTERN void D_SetZeroCurrent(vector_t* const _motor);
EXTERN void D_SetZeroCurrentByVE(vector_t* const _motor, TSB_VE_TypeDef * pVE);
EXTERN bool D_Check_OverCurrent(q15_t _ovc, q15_t _iu, q15_t _iv, q15_t _iw);
EXTERN void D_Control_Current(vector_t* const _motor);
EXTERN void D_Power_Limit(pfc_t * const _pfc, vector_t* const _motor);
EXTERN void D_DecisionOutputMode(vector_t* const _motor, TSB_PMD_TypeDef* const PMDx);
EXTERN void D_GetMotorCurrentPowerVolt(vector_t* const _motor);
EXTERN void D_PowerCompensate(vector_t* const _motor);
EXTERN uint16_t Power_Table(uint16_t m_v);
EXTERN q15_t Cal_Eq(q15_t _id, q15_t _iq, q31_t _vq, q15_t _omega, uint8_t _type);
EXTERN void D_OutputDutyLimit(vector_t* const _motor);
#undef	EXTERN
#endif				/* _D_DRIVER_H */

/*************************** END OF FILE **************************************/
