//Following Tooltip code must be initialized in setup()
  ////Textlabel initialization
  //txtlabel[0] = cp5.addTextlabel("ParameterA").setId(0).setText("Parameter_A").setPosition(20,100).setFont(myFont).setColor(color(10));  // ID should match index
  //txtlabel[1] = cp5.addTextlabel("ParameterB").setId(1).setText("Parameter_B").setPosition(20,200).setFont(myFont).setColor(color(10));
  ////Tooltip setup
  //tt = new TooltipCanvas(); //create a tooltipCanvas
  //tt.post();          // Displays tooltip on top
  //cp5.addCanvas(tt);  //adds tooltip canvas to main form

/////////////////////////////////////////// Following arrays must be set according to the application ////////////////////
// all Textlabels of GUI needs to be in following array
Textlabel[] txtlabel_tabGlobal = new Textlabel[8];  //ID of each textlabel should match its index in this array. //Labels to display tooltip in tabGlobal (Always visible area)
Textlabel[] txtlabel_tabDefault = new Textlabel[26];  //ID of each textlabel should match its index in this array.//Labels to display tooltip in tabDefault (Configuration Control)
Textlabel[] txtlabel_tab1 = new Textlabel[12];  //ID of each textlabel should match its index in this array.  //Labels to display tooltip in tab1 (Sequence Control)
Textlabel[] txtlabel_tab2 = new Textlabel[23];  //ID of each textlabel should match its index in this array. //Labels to display tooltip in tab2 (Motor Control)
Textlabel[] txtlabel_tab3 = new Textlabel[0];  //ID of each textlabel should match its index in this array.  //Labels to display tooltip in tab3 (Registers)
Textlabel[] txtlabel_tab4 = new Textlabel[0];  //ID of each textlabel should match its index in this array.  //Labels to display tooltip in tab4 (NVM)
// Tooltip text must be in following array for each corresponding textlabel in above array.
String[] txtlabelTooltipText_tabGlobal = {  //tabGlobal: always visible area tooltip text    // This is displayed in tooltip based on ID of textlabel
                                "Reg 0   ",
                                "Reg 0[5]  ",    //index=1 thus it is for for textlabel[1]
                                "Reg 0[4]  ",
                                "Reg 0[3]  ",
                                "Reg 0[2]  ",
                                "Reg 0[1]  ",
                                "Reg 0[0]  ",
                                "Reg 29 & 30   "
};
String[] txtlabelTooltipText_tabDefault ={  //tabDefault: Configuration control tooltip text
                                "TSPSEL  15[4]    ",      //0 //SpeedControl
                                "DIR  14[6]   ",            //DirControl
                                "BRK_INV  18[4]    ",        //Brake
                                "SPDINV  15[3]    ",         //SpeedControlInverse
                                "LA  21[7:4]   ",            //LeadAngle
                                "FPWM  22[4:2]    ",         //OutPwmFreq
                                "SOURCE  23[5:3]     ",           //SourceCurrent
                                "SINK  23[2:0]   ",             //SinkCurrent
                                "DUTYCHGLIMIT  16[6:4]      ",    //DutyChangeLimit
                                "DUTY_UP_TIME  17[0]      ",      //DutyChangeTime
                                "DEADTIME  22[1:0]     ",    //10 //DeadTime
                                "ANTITHROUGH  18[0]      ",      //AntiThrough
                                "OCPDIS  16[0]    ", //12     //OcpMask
                                "ISD_MASK  18[3]     ",      //IsdMask
                                "TSD_MASK  19[0]      ",      //TsdMask
                                "LOCKDIS  16[7]    ",      //LockMask
                                "VCP_MASK  11[1]     ",      //VcpMask
                                "OCP_LVL  23[6]    ",      //OcpLevel
                                "RS_SEL  18[2:1]    ",      //RsaFilter
                                "ISD_LVL  23[7]  ",      //IsdLevel
                                "OCPMASK  15[1:0]      ",  //20    //MaskTime
                                "FMAX  21[3:2]    ",      //FMAX
                                "LOCK_BRK  19[2]     ",      //LockStatus
                                "ALERTINV  19[1]    ",      //AlertStatus
                                "LATCH  15[2]    ",      //Latch
                                "TRE  20[7:5]    "      //RestartTime
};
String[] txtlabelTooltipText_tab1 ={    //tab1: Sequence control tooltip text
                                "STBY_MODE  14[7]     ",  //0  //STBY Control
                                "PreTIP  20[4:3] ",  //1stDCTime
                                "TIP  20[2:0] ",  //DCTime
                                "FST  21[1:0]  ",  //ForcedFreq
                                "COMP_HYS  24[7:4]    ",  //CompHys
                                "STARTCURRENT  16[3:1]     ",  //StartCurrent
                                "SS_ADD_SEL  17[7:6]    ",  //TargetCurrent
                                "SS_UP_SEL  17[5:4]    ",  //CurrentIncr
                                "SS_DUTYCHGLIMIT  17[3:1]     ",  //SStartDuty
                                "WAIT_TIME  19[7:5]   ",  //WaitTime
                                "WAIT_MODE  19[4]    ",  //10 //WaitMode
                                "WAIT_CON  19[3]    "  //AfterWait
};
String[] txtlabelTooltipText_tab2 = {    //tab2: Motor control tooltip text
                                "OPENLOOP 11[0]     ", //0  //OpenLoopCloseLoop
                                "NOSTOP 2[7]    ",       //NoStop
                                "MAXOFF 9[0]    ", //2   //MaxOff
                                "MAXOPEN 9[1]     ",      //MaxOpen
                                "STARTDUTY 3 & Slope     ",        //StartDuty
                                "STOPDUTY 2[6:0]    ",   //StopDuty
                                "If OpenLoop:(STARTRPM 6 & Slope)    else:(STARTRPM 6,7[7:4] & Slope)  ",        //MinOutput
                                "MAXDUTY 5  & Slope    ",        //MaxDuty
                                "Slope (SPEEDSLOP 8,9[7:2], SPEEDSLOP2 10,11[7:2])     ", //MaxOutput
                                "MAXDUTYHYS 7[3:0]     ",    //MaxDutyHys
                                "CHANGEDUTY 4  & Slope      ",         //10 //ChangePointEn
                                "CHANGEDUTY 4  & Slope      ",              //ChangeDuty
                                "Slope (SPEEDSLOP 8,9[7:2], SPEEDSLOP2 10,11[7:2])     ",       //ChangeOutput
                                "KP 13[6:0]  ",    //kP
                                "KPX 13[7]    ",      //KPX
                                "KI 12[6:0]  ",    //KI
                                "KIX 12[7]    ",      //KIX
                                "RPMLIMIT 18[7:5]   ",    //RPMLimit
                                "FGSEL 15[7:5]   ",    //FGSEL
                                "FG_ON 14[0]    ",      //FG_ON
                                "SPD 27,28[7:6]  ", //20 //SPD
                                "POLEPAIR 14[5:3]    ",    //Polepair
                                "MAXSPEED 14[2:1]     "     //MaxSpeed      
                              };
String[] txtlabelTooltipText_tab3 ={   //tab3: Registers tooltip text
};
String[] txtlabelTooltipText_tab4 ={   //tab4: NVM tooltip text
};

////////////////////////////////////////  TOOLTIP for ControlP5 Textlabels  ///////////////////////////////////////////////

class TooltipCanvas extends Canvas {

  final float controllerWidthMultiplier = 0.75; //Multiplication is done only for textlabel, because cp5 textlabel width is fixed by default //set it so it fits all textlabels
  final int tooltipBackgroundWidthMultiplier = 8; //To adjust the width of tooltip background. //Needs to be modified if tooltip font is changed
  final int tooltipFontSize = 17; //Font size for Tooltip text
  int count=0;
  boolean mouseStoppedFlag = false;     // indicates stopped state of mouse     //true: Mouse is stopped, false: Mouse is moving
  boolean controllerSearchFlag = false; // indicates start of controller search //Becomes true: when mouse stops after movement, becomes false: when controller search starts 
  boolean tooltipDisplayFlag_globalTab = false;   // indicates display status of tooltip in global tab  //Becomes true: when mouse stops and controller is found, becomes false: when mouse moves
  boolean tooltipDisplayFlag_activeTab = false;   // indicates display status of tooltip in active tab //Becomes true: when mouse stops and controller is found, becomes false: when mouse moves
  Textlabel searchResult;
  final int tooltipTriggerDelay = 20;
  

  public void draw(PGraphics pg) {
    checkMouseMovement();
    //println("mouseStopped: "+mouseStoppedFlag);
    //println("controllerSearchFlag: "+controllerSearchFlag);
    //println("tooltipDisplayFlag: "+tooltipDisplayFlag);
    //println("count: "+count);
    if(controllerSearchFlag == true){  //Search starts
       controllerSearchFlag=false;
       
       //Checking if mouse is over any label in Global tab (always visible area)
       for(int i=0; i<txtlabel_tabGlobal.length; i++){  //searching controller
          if(checkMouseOverController(txtlabel_tabGlobal[i])){  //Checking if mouse is over any label in Global tab
            searchResult=txtlabel_tabGlobal[i];    //Get text to be displayed
            tooltipDisplayFlag_globalTab=true;
          }
       }
       //checking if mouse is over any label in active tab
       if(tooltipDisplayFlag_globalTab==false){   //if label is not found in global tab then check in active tab
         if(cp5.getTab("default").isActive()){
            for(int i=0; i<txtlabel_tabDefault.length; i++){  //searching controller 
              if(checkMouseOverController(txtlabel_tabDefault[i])){  //Checking if mouse is over any label in tab2
                searchResult=txtlabel_tabDefault[i];    //Get text to be displayed
                tooltipDisplayFlag_activeTab=true;
              }
            }  
         }else if(cp5.getTab("tab1").isActive()){
            for(int i=0; i<txtlabel_tab1.length; i++){  //searching controller 
              if(checkMouseOverController(txtlabel_tab1[i])){  //Checking if mouse is over any label in tab2
                searchResult=txtlabel_tab1[i];    //Get text to be displayed
                tooltipDisplayFlag_activeTab=true;
              }
            }  
         }else if(cp5.getTab("tab2").isActive()){
            for(int i=0; i<txtlabel_tab2.length; i++){  //searching controller 
              if(checkMouseOverController(txtlabel_tab2[i])){  //Checking if mouse is over any label in tab2
                searchResult=txtlabel_tab2[i];    //Get text to be displayed
                tooltipDisplayFlag_activeTab=true;
              }
            }  
         }else if(cp5.getTab("tab3").isActive()){
            for(int i=0; i<txtlabel_tab3.length; i++){  //searching controller 
              if(checkMouseOverController(txtlabel_tab3[i])){  //Checking if mouse is over any label in tab2
                searchResult=txtlabel_tab3[i];    //Get text to be displayed
                tooltipDisplayFlag_activeTab=true;
              }
            }  
         }else if(cp5.getTab("tab4").isActive()){
            for(int i=0; i<txtlabel_tab4.length; i++){  //searching controller 
              if(checkMouseOverController(txtlabel_tab4[i])){  //Checking if mouse is over any label in tab2
                searchResult=txtlabel_tab4[i];    //Get text to be displayed
                tooltipDisplayFlag_activeTab=true;
              }
            }  
         }
       }
    }
    if(tooltipDisplayFlag_globalTab==true){
      drawTooltip(pg,(txtlabelTooltipText_tabGlobal[searchResult.getId()]));
    }else if(tooltipDisplayFlag_activeTab==true){
         if(cp5.getTab("default").isActive()){
            drawTooltip(pg,(txtlabelTooltipText_tabDefault[searchResult.getId()]));
         }else if(cp5.getTab("tab1").isActive()){
            drawTooltip(pg,(txtlabelTooltipText_tab1[searchResult.getId()]));
         }else if(cp5.getTab("tab2").isActive()){
            drawTooltip(pg,(txtlabelTooltipText_tab2[searchResult.getId()]));
         }else if(cp5.getTab("tab3").isActive()){
            drawTooltip(pg,(txtlabelTooltipText_tab3[searchResult.getId()]));
         }else if(cp5.getTab("tab4").isActive()){
            drawTooltip(pg,(txtlabelTooltipText_tab4[searchResult.getId()]));
         }
    }
  }
   
  private void drawTooltip(PGraphics pg1, String message){
    pg1.fill(0);
    pg1.rect(mouseX+20, mouseY+10, message.length()*tooltipBackgroundWidthMultiplier, 40);
    pg1.fill(255);
    pg1.textFont(createFont("Arial",16));
    pg1.text(message, mouseX+30, mouseY+35);
  }
    
  private boolean checkMouseOverController(Textlabel b){
    boolean result=false;
    float[] position = b.getPosition();
    boolean xCheck = (mouseX>position[0] && mouseX < position[0]+b.getWidth()*controllerWidthMultiplier); 
    boolean yCheck = (mouseY>position[1] && mouseY < position[1]+b.getHeight());
    
    if(xCheck && yCheck)
      result = true;
      
    return result;
  }
  
  private void checkMouseMovement(){
    if(mouseX==pmouseX && mouseY==pmouseY){
       if(count>tooltipTriggerDelay){
         if(mouseStoppedFlag==false){   //if mouse was moving before this
           controllerSearchFlag=true;   //this will start controller search
         }
         mouseStoppedFlag=true;         //this will prevent "controller search start" until mouse moves and stops again.
       }else{
         count++;
       }
    }else{
      count=0;
      mouseStoppedFlag=false;   //mouse is not stopped, i.e. moving
      tooltipDisplayFlag_globalTab=false; //tooltip is not displayed because mouse is moving
      tooltipDisplayFlag_activeTab=false; //tooltip is not displayed because mouse is moving
    }
  }
}
