//
// IH Cooker Sample Program
//

#include "Include.h"

volatile u8 OverVoltageCnt,UnderVoltageCnt,OverCurrentCnt;
volatile u8 ErrRecoveryTimer;
volatile u8 IGBTOverVoltageCnt;
volatile u8 OverPADtemper_Cnt,OverPADtemper_Cnt1;
volatile u8  ucOverI_S_Cnt;
volatile u8  ucNtc_HotTIME;
volatile u16 uiOvertemperCnt68;
volatile u16 u16ErrorBuf = 0;

volatile HW_State_type  HW_State_type1;

void  ProtectWithAD_Task()
{
	static u8 OverIGBTtemper_Cnt=0;	
	if(AD_DataReady == 1)
	{
		//---- Over Voltage Detect ----
		if (AD_Vac>=c_MaxVol)
		{
			if (OverVoltageCnt < c_OverVoltageCnt_TH)
				OverVoltageCnt++;
			else
			{
				bErrOverVoltage=1;
				ErrRecoveryTimer=c_ErrRecoveryTime;
			}
		}
		else if (OverVoltageCnt>0) 
		{
			OverVoltageCnt--;
		}

		if(1==bErrOverVoltage)
		{
			IGBT_Off();
			bErrPowerOff=1;
			u16ErrorBuf |=0b0000000000000001;
			IH_Status_App.flagBit.error=ERROR_OVP;
		}

		//---- Low Voltage Detect ----
		if (AD_Vac<c_MinVol)
		{
			if (UnderVoltageCnt < c_UnderVoltageCnt_TH)
				UnderVoltageCnt++;
			else
			{
				bErrUnderVoltage=1;
				ErrRecoveryTimer=c_ErrRecoveryTime;
			}
		}
		else if (UnderVoltageCnt>0) 
		{
			UnderVoltageCnt--;
		}

		if(1==bErrUnderVoltage)
		{
			IGBT_Off();
			bErrPowerOff=1;
			u16ErrorBuf |=0b0000000000000010;
			IH_Status_App.flagBit.error=ERROR_UVP;
		}
		//---- Over Current Detect ----
		if (AD_Iac>=c_AD_MaxCurrent)
		{
			if (OverCurrentCnt < c_OverCurrentCnt_TH)
				OverCurrentCnt++;
			else
			{
				bErrOverCurrent=1;
				ErrRecoveryTimer=c_ErrRecoveryTime;
				u16ErrorBuf |=0b0000000000000100;
			}
		}
		else if (OverCurrentCnt>0) 
		{
			OverCurrentCnt--;
		}
		
		//---- Error Processing ----
		if ( (1==bIgbtNtcError) || (1==bPadNtcError) || (1==bErrOverCurrent) )
		{
			bErrPowerOff=1;	

			if(1==bErrOverCurrent)
			{
				IH_Status_App.flagBit.error=ERROR_OCP;
				u16ErrorBuf |=0b0000000000001000;
			}

			if(1==bIgbtNtcError)
			{
				if(AD_TempIGBT>=c_NTC_OPENCIRCUIT)
				{
					IH_Status_App.flagBit.error=ERROR_IGBT_NTC;
				}
				if(AD_TempIGBT<=c_NTC_SHORTCIRCUIT) 
				{	
					IH_Status_App.flagBit.error=ERROR_IGBT_NTC;
				}
				u16ErrorBuf |=0b0000000000010000;
			}
			if(1==bPadNtcError)
			{
				if(AD_TempPad>=c_NTC_OPENCIRCUIT)
				{
					IH_Status_App.flagBit.error=ERROR_PAN_NTC;
				}
				if(AD_TempPad<=c_NTC_SHORTCIRCUIT)
				{
					IH_Status_App.flagBit.error=ERROR_PAN_NTC;
				}
				u16ErrorBuf |=0b0000000000100000;
			}
			if (bMachineOnState==ON)
			{
				PowerOffProc();
			}
		}

		//---- Over temperature Detect ----
		if (bMachineOnState==ON)
		{
			if(2==CookMode) 
			{
				if ((AD_TempPad>=c_T_PAD_OTEMP)&&(AD_TempPad<c_NTC_OPENCIRCUIT) ) 
				{
					if (OverPADtemper_Cnt < c_OvertemperCnt)
						OverPADtemper_Cnt++;
					else
					{
						bErrPAD_Otemper=1;
						bErrPAD_Otemper_ForOn=1;
						u16ErrorBuf |=0b0000000001000000;
					}
				}
				else if (OverPADtemper_Cnt>0) 
				{
					OverPADtemper_Cnt--;
				}
			}
			else
			{
				if ((AD_TempPad>=c_T_PAD_OTEMP1)&&(AD_TempPad<c_NTC_OPENCIRCUIT)) 
				{
					if (OverPADtemper_Cnt1 < c_OvertemperCnt)
						OverPADtemper_Cnt1++;
					else
					{
						bErrPAD_Otemper=1;	
						bErrPAD_Otemper_ForOn=1;
						u16ErrorBuf |=0b0000000010000000;
					}
				}
				else if (OverPADtemper_Cnt1>0) 
				{
					OverPADtemper_Cnt1--;
				}
			}
			if(1==bErrPAD_Otemper)
			{
				IGBT_Off();
				bErrPowerOff=1;
                u16ErrorBuf |=0b0000000100000000;
				IH_Status_App.flagBit.error=ERROR_PAN_OVER_TMP;
				if (AD_TempPad <c_T_PAD_RECOVER)
				{
					bErrPAD_Otemper=0;
					bErrPowerOff=0;
					OverPADtemper_Cnt=0;
					OverPADtemper_Cnt1 = 0;
					IH_Status_App.flagBit.error=ERROR_NO;
					
				}
			}	
		}	
		else
		{
			bErrPAD_Otemper=0;
			OverPADtemper_Cnt=0;
			OverPADtemper_Cnt1 = 0;
		}

		if (bMachineOnState==ON)
		{
			if ( AD_TempIGBT<=c_T_IGBT_OTEMP&&(AD_TempIGBT>c_NTC_SHORTCIRCUIT))
			{
				if (OverIGBTtemper_Cnt < c_OvertemperCnt)
					OverIGBTtemper_Cnt++;
				else
				{
					bErrIGBT_Otemper=1;
					bErrIGBT_Otemper_ForOn=1;
					u16ErrorBuf |=0b0000001000000000;	
				}	
			}	
			else if (OverIGBTtemper_Cnt>0) 
			{
				OverIGBTtemper_Cnt--;
			}
			
			if(1==bErrIGBT_Otemper)
			{
				IGBT_Off();
				bErrPowerOff=1;
				IH_Status_App.flagBit.error=ERROR_IGBT_OVER_TMP;
				
				if (AD_TempIGBT >c_T_IGBT_RECOVER)
				{
					bErrIGBT_Otemper=0;
					bErrPowerOff=0;
					OverIGBTtemper_Cnt=0;
					IH_Status_App.flagBit.error=ERROR_NO;
				}
			}
		}
		else
		{
			bErrIGBT_Otemper=0;
			OverIGBTtemper_Cnt=0;
		}
	}
}

void  ProtRecoverySlow()
{
	if (ErrRecoveryTimer>0) 
	{
		ErrRecoveryTimer--;
		if (ErrRecoveryTimer==0) 
		{
			if(1==bErrOverCurrent)
			{
				bErrOverCurrent=0;
			}
			if((1==bErrOverVoltage)||(1==bErrUnderVoltage))
			{
				bErrOverVoltage=0;
				bErrUnderVoltage=0;
				bErrPowerOff=0;
				IH_Status_App.flagBit.error=ERROR_NO;
			}
			if(1==bSurgeHW||1==bOverCurrentHW)
			{
				bSurgeHW=0;
				bOverCurrentHW=0;
				bErrPowerOff=0;
			}
			if((1==bOverVoltageHW))
			{
				bOverVoltageHW=0;
				_rlbf=0;
			}
		}
	}
}

void SurgeCurrent_Protect()
{
	if(1==bSurgeHW)
	{
		IGBT_Off();
		bErrPowerOff=1;
#ifdef UART_ASCII
		uart_put_char('*');
		uart_put_char(0x0d);
		uart_put_char(0x0A);
#endif
        u16ErrorBuf |=0b0000010000000000;
        
	}
		
	if(1==bOverCurrentHW)
	{
		IGBT_Off();
		bErrPowerOff=1;
	    u16ErrorBuf |=0b0001000000000000;
	}
}


void ISR_CP2CP3_INIT()
{
	_cp1e=1;
	_cp1f=0;
	_cp2e=1;
	_cp2f=0;
	_cp3e=1;
	_cp3f=0;
	_rlbf=0;

	_ovpf = 0;
	_ovpe = 1;
}

void OverCurrentHW_Cnt()
{
   if(1==bOverCurrentHW_RE)
   {
   	 if(ucOverI_S_Cnt<20)
   	    ucOverI_S_Cnt++;
   }
}

static volatile u8 ucNtc_IgbtError_CNT __attribute__((at(0x189)));
static volatile u8 ucNtc_PadError_CNT __attribute__((at(0x18A)));

void Ntc_Detect()
{
	if ( ( (bMachineOnState==ON)&&(CookMode!=0) )||(u8_ModeSet==2))
	{
		//----------------------IGBT NTC trouble
			if( (AD_TempIGBT>=c_NTC_OPENCIRCUIT)||(AD_TempIGBT<=c_NTC_SHORTCIRCUIT) )
			{
				if(ucNtc_IgbtError_CNT<c_NTC_TIMEOUT)  
				{
					ucNtc_IgbtError_CNT++;
				}
				else
				{
					bIgbtNtcError=1;
				}
			}
			else
			{
				ucNtc_IgbtError_CNT=0;	
			}
		//-------------------------PAD NTC trouble
			if( (AD_TempPad >= c_NTC_OPENCIRCUIT)||(AD_TempPad <= c_NTC_SHORTCIRCUIT ) ) 
			{
				if(ucNtc_PadError_CNT<c_NTC_TIMEOUT)
				{
					ucNtc_PadError_CNT++;
				}
				else
				{
					bPadNtcError=1;
				}
			}
			else
			{
				ucNtc_PadError_CNT=0;
			}
	}
	else
	{
		ucNtc_HotTIME=0;
		bIgbtNtcError=0;
		bPadNtcError=0;
		ucNtc_IgbtError_CNT=0;
		ucNtc_PadError_CNT=0;
	}
}

//---- Over temperature Detect ----
void OverTEMP_PowerDrop()
{		
	if (bMachineOnState==ON)
	{
		if (AD_TempIGBT<=c_T_IGBT_POWERDROP)
		{
		    if(uiOvertemperCnt68< c_5Min)
		    {
		    	uiOvertemperCnt68++;
		    }
		    else
		    {
		    	bProtect68=1;
		    }
		}
		else if (uiOvertemperCnt68>0)
		{
			uiOvertemperCnt68--;
		}
	}
	else
	{
		uiOvertemperCnt68=0;
	}
	if(1==bProtect68)
	{
		if (AD_TempIGBT>c_T_IGBT_POWERDROP1)
		{
			bProtect68=0;
			uiOvertemperCnt68=0;
			bPowerStepChanged=1;
		}
	}
}
