//
// IH Cooker Sample Program
//

#include "Include.h"

volatile u8 PanMoveInDet;
volatile u16 Ichanged;
volatile u8  StartWorkCount;
volatile u8 last1IAC, last2IAC; 

volatile u8 PanDetPulseCnt;
volatile u8 NoPanDetectedCnt;

void  StartPanDetect()
{
	PanMoveInDet=PAN_DET_TIMER_100MS;
	IGBT_Off();
}

void  PanDetTrigger()
{
	if ((PanMoveInDet==0)&&(bPowerState==0)&&(bErrPowerOff==0))
	{
		StartPanDetect();
	}
}

void  PanMoveOutDetect() //run every 100mS
{
	volatile u8 OffCurrent_TH_temp;
	if (bMachineOnState==ON)
	{
		OffCurrent_TH_temp=OffCurrent_TH;
		if ((AD_Iac<last1IAC) || (last1IAC<last2IAC) || (AD_Iac< OffCurrent_TH_temp))
		{
			if (AD_Iac<last1IAC)	Ichanged+=(last1IAC-AD_Iac);
			else  					Ichanged+=(AD_Iac-last1IAC);
			
			if (last2IAC<last1IAC)  Ichanged+=(last1IAC-last2IAC);
			else					Ichanged+=(last2IAC-last1IAC);

			if (Ichanged>250) Ichanged=250;
			if (StartWorkCount<25)	Ichanged=0;
			
			if ((bPowerState==1) && (StartWorkCount> 25)) //25x100mS = 2.5Sec 
			{
				if (AD_Iac<OffCurrent_TH_temp)
				{
					if(1==bPanDetectedOut)
					{
						StartPanDetect();
					}
					bPanDetectedOut=1;
				}
			}
		}
		last2IAC=last1IAC;
		last1IAC=AD_Iac;
	}
}

u8 SBR_PANDET()
{
	u8 v_IntCnt = 0;
	volatile bit v_buf2 = 0;
	u8 i;
	if(_c2cmpop == 1)
	{
		_emi = DISABLE;

		_ppgta8 = 1;

		_ppgta = c_PAN_DETECT_PPGTA;

		_ppgc0 = 0b10100010;
		while(_pst == 1);

		for(i = 0;i<200;i++) 
		{
			if(_c0cmpop != v_buf2)
			{
				v_IntCnt++;
			}
			v_buf2 = _c0cmpop;
			GCC_NOP();
			GCC_NOP();
			GCC_NOP();
			GCC_NOP();
			GCC_NOP();
			GCC_NOP();
		}
		_emi = ENABLE;
	}
    return v_IntCnt;
}

void  PanMoveInDetect()	//run every 100mS
{
	volatile u8 PanDetectPulseTH_Temp;
	
	if (PanMoveInDet>1)
		PanMoveInDet--;
	else if ((PanMoveInDet==1)&&(bPowerState==0)&&(bErrPowerOff==0))
	{
		PanMoveInDet=0;
		PanDetPulseCnt=SBR_PANDET();

		if (PanDetPulseCnt==0) 
			PanDetPulseCnt=255;

		PanDetectPulseTH_Temp=c_PanDetectPulseTH;
		if (PanDetPulseCnt> PanDetectPulseTH_Temp)
		{
			bPanDetectedIn=0;
			IH_Status_App.flagBit.NoPan=NO_PAN;
			ControlSet_App.flagBit.beep=BEEP_200MS;
		  	bNoPAD=1;

			if (NoPanDetectedCnt<c_NoPanDetectedOff)
				NoPanDetectedCnt++;
			else
			{
				bErrPowerOff=1;
				NoPanDetectedCnt=0;
				ErrRecoveryTimer=c_ErrRecoveryTime;
				if (bMachineOnState==ON) 
				{
					PowerOffProc();
					ControlSet_App.flagBit.beep=BEEP_200MS;
				}
			}
		}
		else
		{
			IH_Status_App.flagBit.NoPan=HAVE_PAN;
			bNoPAD=0;
			bPanDetectedIn=1;
			bPanDetectedOut=0;
			NoPanDetectedCnt=0;
			if (bPowerState==0)
			{
				IGBT_PowerOn();
				StartWorkCount=0;
			}
		}
	}
}
