//
// IH Cooker Sample Program
//

#include"Include.h"

void CMP_OPA_Init()
{	
	_c0en=1;
	_c1en=1;
	_c3en=1;
	_c2en=1;
	_open=1;

	CALIBRATION_CMP(CP3C_ADDR);	
	CALIBRATION_CMP(CP2C_ADDR);	
	CALIBRATION_CMP(CP1C_ADDR);	
	CALIBRATION_CMP0();
	CALIBRATION_OPA(); 
	CALIBRATION_CMP(OVPC1_ADDR);   

	//OPA
	_opc = 0b01000000;
	_ops = 0b00000110;

	//CMP 
	_cmpvref0 = 0b01000000;
	_cmpvref1 = 0b01110000;
	_cmpctl0  = 0b00000111;
	_cmpctl1  = 0b01010000;
	_cmpdbc0  = 0x04;
	_cmpdbc1  = 0b11110000;
	_cmphys   = 0x00;

	//OVP
	_ovpc0    = 0b00000111;
	_ovpc2    = 0b00000110;
	_ovpda    = 95;
	_ovpen=ENABLE;

	_c3ctl1 = 0;
	_c3ctl0 = 1;
	_c3en=0;
}

void CALIBRATION_OPA()
{
	volatile u8 i,tmp1,tmp2;
	_opvos =0B11000000;
	GCC_DELAY(2000);

	tmp1=_opo;
	for(i=0;i<63;i++)
	{
		_opvos++;
		GCC_DELAY(500);
		GCC_CLRWDT();

		GCC_CLRWDT();
		if(_opo != tmp1)
		{
			GCC_NOP();
			break;
		}
	}
	tmp2=i;

	_opvos =0B11111111;
	tmp1=_opo;
	for(i=63;i>0;i--)
	{
		_opvos--;
		GCC_DELAY(500);
		GCC_CLRWDT();
		if(_opo!=tmp1)
		{
			GCC_NOP();
			break;
		}
	}
	tmp2=tmp2+i;
	tmp2=tmp2>>1;
	_opvos =0b00000000;
	_opvos=_opvos+tmp2;
}

void CALIBRATION_CMP0()
{
	volatile u8 i,tmp1,tmp2;
	_cmp0c =0B11000000;
	GCC_DELAY(1000);

	tmp1=_c0cmpop;
	for(i=0;i<63;i++)
	{
		_cmp0c++;
		GCC_DELAY(500);
		GCC_CLRWDT();
		if(_c0cmpop != tmp1)
		{
			GCC_NOP();
			break;
		}
	}
	tmp2=i;

	_cmp0c =0B11111111;
	tmp1=_c0cmpop;
	for(i=63;i>0;i--)
	{
		_cmp0c--;
		GCC_DELAY(500);
		GCC_CLRWDT();
		if(_c0cmpop!=tmp1)
		{
			GCC_NOP();
			break;
		}
	}
	tmp2=tmp2+i;
	tmp2=tmp2>>1;
	_cmp0c =0b00000000;
	_cmp0c=_cmp0c+tmp2;
}

void CALIBRATION_CMP(u8 addr)
{
	volatile u8 i,tmp1,tmp2;
	_mp0=addr;
	_iar0=0B01100000;
	GCC_DELAY(1000);

	tmp1=_iar0&0x80;
	for(i=0;i<31;i++)
	{
		_iar0++;
		GCC_DELAY(500);
		GCC_CLRWDT();
		if((_iar0&0x80)!=tmp1)
		{
			GCC_NOP();
			break;
		}			
	}
	tmp2=i;

	_iar0=0B01111111;
	tmp1=_iar0&0x80;
	for(i=31;i>0;i--)
	{
		_iar0--;
		GCC_DELAY(500);
		GCC_CLRWDT();
		if((_iar0&0x80)!=tmp1)
		{
			GCC_NOP();
			break;
		}
	}
	tmp2=tmp2+i;
	tmp2=tmp2>>1;
	_iar0 =0b10000000;
	_iar0=_iar0+tmp2;
}
