//
// IH Cooker Sample Program
//

#include "Include.h"


volatile u8 ADCUR,ADVOL,ADIGBT,ADPAD; 
volatile u8 AD_Vac,AD_Iac,AD_TempPad,AD_TempIGBT,AD_DataReady;

volatile u8 maxAD_Vac = 0;
volatile u8 maxAD_Iac = 0;
volatile u8 maxAD_TempPad = 0;
volatile u8 maxAD_TempIGBT = 0;

bit Fg_AD_Convert_Ok;
volatile u8 Adrl_Buf=0,Adrh_Buf=0,Ad_ChannelIndex=0;

void ADC_Init(void)
{	
	_sadc1 = 0b00001100;
	_sadc0 = 0x22;
	
	AD_DataReady=1; 
	ADC_Start();
}

void  ADC_Task()
{
	if (AD_DataReady==1)
	{
		AD_Vac = ADVOL;
		AD_Iac = ADCUR;
		AD_TempPad = ADPAD;
		AD_TempIGBT = ADIGBT;


		if( AD_Vac > maxAD_Vac )
		{
			maxAD_Vac = AD_Vac;
		}
		if( AD_Iac > maxAD_Iac )
		{
			maxAD_Iac = AD_Iac;
		}
		if( AD_TempPad > maxAD_TempPad )
		{
			maxAD_TempPad = AD_TempPad;
		}
		if( AD_TempIGBT > maxAD_TempIGBT )
		{
			maxAD_TempIGBT = AD_TempIGBT;
		}
	}	
} 

void  ADC_Start()
{
	if (AD_DataReady==1)
	{
		AD_DataReady=0;
		bAD_StartCapture=1;
	}
}


void AD_Convert()
{
	switch(Ad_ChannelIndex)
	{
		case 0:  //ADVOL
			_sacs3 = 0;
			_sacs2 = 0;
			_sacs1 = 0;
			_sacs0 = 1;
		break;

		case 1:  //ADPAD
			_sacs3 = 0;
			_sacs2 = 0;
			_sacs1 = 1;
			_sacs0 = 0;
		break;

		case 2:  //ADCIR
			_sacs3 = 0;
			_sacs2 = 1;
			_sacs1 = 0;
			_sacs0 = 0;
		break;

		case 3:  //ADIGBT
			_sacs3 = 0;
			_sacs2 = 1;
			_sacs1 = 0;
			_sacs0 = 1;
		break;

		default:
		break;
	}
	_start=0;
	GCC_NOP();
	_start=1;
	GCC_NOP();
	_start=0;
	while(_adbz);   //poll the ADCR regsiter EOCB bit to detect end of A/D conversion	
    Adrl_Buf = _sadol;
    Adrh_Buf = _sadoh;
    Fg_AD_Convert_Ok=1;
}    


void Ad_Deal()
{
	static u32 v_buf_acc=0;
	static u16 v_buf_min=0,v_buf_max,v_buf=0;
	static u8 AD_cnt=0;
    if (bAD_StartCapture==1)
    {
	    AD_DataReady = 0;
		if(1==Fg_AD_Convert_Ok)
		{
			Fg_AD_Convert_Ok=0;
				
			v_buf=(Adrh_Buf<<4)+(Adrl_Buf>>4);
			if(!AD_cnt)
			{
				v_buf_min=v_buf;
				v_buf_max=v_buf;
				v_buf_acc=0;
			}
			else
			{
				if(v_buf_min>v_buf)
				{
					v_buf_min=v_buf;
				}
				if(v_buf_max<v_buf)
				{
					v_buf_max=v_buf;
				}
			}
			v_buf_acc=v_buf_acc+v_buf;

			AD_cnt++;
			if(AD_cnt>=10)
			{
				AD_cnt=0;
				v_buf_acc=(v_buf_acc-v_buf_max-v_buf_min)>>3;
			    switch(Ad_ChannelIndex)
			    {
					case 0:
					    ADVOL=v_buf_acc>>4;
						break;
			    	case 1:
				      	ADPAD=v_buf_acc>>4;
						break;
		            case 2:
						ADCUR=v_buf_acc>>4;
						break;
					case 3:
						ADIGBT=v_buf_acc>>4;
						break;
					default:
						break;
			    }
				Ad_ChannelIndex++;
			    if(Ad_ChannelIndex >= 4)
			    {
			       Ad_ChannelIndex=0;
			       AD_DataReady = 1;
			       bAD_StartCapture=0;
			    }
			}
		}
    }
}
