//
// IH Cooker Sample Program
//

#include <HT45F0058.H>
#include"Include.h"


void Timer0Initial(void)
{
	_tmr0c=0b10010101;   		//Timer mode,Fsys/32   
//                   ||||||||	
//	b7: _t0m1 -------||||||||
//	b6: _t0m0 --------|||||||
//	b5:  N/A-----------||||||
//	b4: _t0on ----------|||||
//  b3: _t0e ------------||||
//	b2: _t0psc2 ----------|||
//	b1: _t0psc1 -----------||
//	b0: _t0psc0 ------------|

	_tmr0=256-250;				//1ms = 4uS * 250 (50Hz)
	_t0e=1;
	_t0on=1;
}

void Timer2Initial(void)
{
	_tmr2c=0b10000101;   		//Timer mode,Fsys/32   
	_tmr2=256-200;				//1ms = 2uS * 125  (60Hz)
	_t2e=1;
	_t2on=1;
}

void TimeBase()	//1ms 
{
	static u8 Timer50mS;
	static u8 Timer20mS ;
	static u8 Timer100mS ;
	static u8 Timer1S;
	Timer20mS++;
	if (Timer20mS >= 20)
	{
		Timer20mS=0;
		T20mS_event=1;
		Timer100mS++;
		if (Timer100mS>=5) //20mS x 5
		{
			Timer100mS=0;
			T100mS_event=1;
			Timer50mS++;
			Timer1S++;
		}	
		if(Timer50mS>=5)
		{
			T500mS_event=1;
			Timer50mS=0;
		}
		if(Timer1S>=10)
		{
			T1S_event=1;
			Timer1S=0;
		}
	} 
}
