/**
 ****************************************************************************
 * @file     dac_drv.h
 * @brief    DAC IC Control for AD5624 on SIO.
 * @version  V1.0
 *
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2021
 *****************************************************************************
 */
#ifndef _DACDRV_H
#define _DACDRV_H

#undef EXTERN
#ifdef DEFINE_APP
#define EXTERN
#else
#define EXTERN  extern
#endif

/*===================================================================*
  Macro Definition
 *===================================================================*/

/* Setting ~SYNC port */
#define PORT_DAC_SYNC				TSB_PA_DATA_PA6
#define PORT_DAC_SYNC_DATA_INI		(TSB_PA->DATA |= (1 << 6u))
#define PORT_DAC_SYNC_CR_INI		(TSB_PA->CR |= (1 << 6u))

/* Setting SIO */
#define DAC_SIO_CH					TSB_SC1
#define DAC_IRQ_INTTX				INTTX1_IRQn

#define DAC_IRQ_LEVEL				INT_DAC_LEVEL
#define DAC_MAX_CH					4					/* MAX channel */


/*===================================================================*
  Definition of variable
 *===================================================================*/
EXTERN	uint16_t	DacData[4];


/*===================================================================*
  Proto Type Definition
 *===================================================================*/
EXTERN	void	init_Dac(TSB_SC_TypeDef * const SCx);
EXTERN	void	DacWriteStart(TSB_SC_TypeDef * const SCx);
EXTERN	void	DacWriteContinue(TSB_SC_TypeDef * const SCx);

#undef EXTERN
#endif  /* _DACDRV_H */


/*************************** END OF FILE **************************************/
