// Grove-C（電流センサ）デモ表示用スケッチ（プログラム）
// Processing:ver 3.5.3 
// Date:2019.05.29    by M.T.
// ------------------------------------------------------
import processing.serial.*;

static final String COM = "COM3";  // Arduino の通信ポート名を設定する
static final int DATA_RESOLUTION = 10;   // bits
static final int RECEIVE_NUM = (DATA_RESOLUTION / 7 + 1);
static final int START_BYTE = 0xFE;
static final int END_BYTE = 0xFF;
static final int DISPLAY_NUM = 1000;
static final int DISPLAY_X_PIXEL = DISPLAY_NUM;  // X pixel
static final int DISPLAY_Y_PIXEL = 512;          // Y pixel
static final int SAMPLING_RATE = 100;    // Hz

Serial serial;

int[] data;
int data_index, value;
boolean data_flag, renew_flag;
int[] pulse_view;
int  cnt;
boolean running = true;
boolean Pulse = false;
boolean QS = false;

void settings() {
  size(DISPLAY_X_PIXEL, DISPLAY_Y_PIXEL, FX2D);
  smooth();
}

void setup() {
  frameRate(SAMPLING_RATE*2);

  // set up serial communication
  serial = new Serial(this, COM, 115200);
  data = new int[RECEIVE_NUM];
  data_index = 0;
  data_flag = false;

  // set up pulse wave form
  pulse_view = new int[DISPLAY_NUM];
  
  serial.clear();
}

void draw() {
  if (renew_flag) {
    renew_flag = false;
    renewData();
    cnt++;
    if (cnt>1) {
      background(255);
      drawData();
      cnt = 0;
      fill(240);
      rect(420, 10, 250, 40, 10);

      textSize(28);
      fill(255, 0, 0);
      text( "Current : " + nf((float)(value-41)*2500.0/1023.0/1000.0,1,2) +" A", 435, 41);
    }
  }
  //println(frameRate);
}

// データ更新
void renewData() {
  value = ((data[0] & 0x07) << 7) + (data[1] & 0x7F);

  for (int i = 0; i < pulse_view.length - 1; i++) {
    pulse_view[i] = pulse_view[i + 1];
  }

  pulse_view[pulse_view.length - 1] = value * DISPLAY_Y_PIXEL / (1 << DATA_RESOLUTION);  // 生データ

}

// 波形描画
void drawData() {
  strokeWeight(1);
  for (int i = 0; i < pulse_view.length - 1; i++) {
    stroke( 0, 0, 255);      // draw line in Blue
    line(i, DISPLAY_Y_PIXEL-pulse_view[i], (i + 1), DISPLAY_Y_PIXEL-pulse_view[i + 1]);
  }

  fill(255, 0, 0);
  textSize(16);
  stroke(200);               // draw line in gray
  line(0, 0, DISPLAY_X_PIXEL, 0);
  line(0, DISPLAY_Y_PIXEL/2, DISPLAY_X_PIXEL, DISPLAY_Y_PIXEL/2);
  for (int i = 1; i < pulse_view.length/SAMPLING_RATE; i++) {
    line(i*SAMPLING_RATE, 0, i*SAMPLING_RATE, DISPLAY_Y_PIXEL-20);
    text(i+"s", i*SAMPLING_RATE-5, DISPLAY_Y_PIXEL-2);
  }
  //fill(100);
  //text( "fps = " + int(frameRate), 15, 15);
}

// シリアル受信
void serialEvent(Serial p) {
  int cmd = p.read();

  switch(cmd) {
  case START_BYTE:
    data_flag = true;
    data_index = 0;
    break;
  case END_BYTE:
    renew_flag = true;
    break;
  default:
    if (data_flag == true) {
      data[data_index] = cmd;
      data_index++;
      if (data_index >= RECEIVE_NUM) {
        data_index = 0;
        data_flag = false;
      }
    }
    break;
  }
}

// マウスで描画のポーズ/再開切替
void mousePressed() {
  if (running) {
    noLoop();
    running = false;
  } else {
    serial.clear();
    running = true;
    loop();
  }
}
